﻿<%@ import Namespace="System.Collections.Generic" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Przeszeregowania" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >

<script runat="server">

    bool grupowanieWgWydziałów = true;
    bool stanowisko = true;

    public class Params : BaseParams {

        public Params(Context context)
            : base(context) {
        }
    }

    Params pars;
    [Context]
    public Params Pars {
        set { pars = value; }
    }

    protected void dc_ContextLoad(object sender, EventArgs e) {
    
        if (!grupowanieWgWydziałów) {        
            Grid.GroupData0="";
            Grid.GroupLine="";
            Grid.ShowGroupSum = false;
        }
        if (!stanowisko) {
            colStanowisko.Visible = false;
            dc.Landscape = false;
        }

        Log progress = new Log();

        Session new_session = dc.Session.Login.CreateSession(false, false);

        Przeszeregowanie przeszeregowanie = (Przeszeregowanie)new_session[pars.Przeszeregowanie];

        ReportHeader["NAZWA"] = przeszeregowanie.Nazwa;
        ReportHeader["DATA"] = przeszeregowanie.Data.ToString();
        
        Context context = dc.Context.Clone(new_session);

        SymulacjaWynagrodzenia symulacja = new SymulacjaWynagrodzenia(przeszeregowanie, progress, context);

        List<SymulacjaPracownika> symulacje = new List<SymulacjaPracownika>();
        foreach (SymulacjaPracownika sp in symulacja.Symulacje)
            symulacje.Add(sp);
            
        if (!grupowanieWgWydziałów)
            symulacje.Sort(new WgPracowników());
        Grid.DataSource = symulacje;  
    }
    
    class WgPracowników: IComparer<SymulacjaPracownika> {
        public int Compare(SymulacjaPracownika a, SymulacjaPracownika b) {
            return a.Pracownik.CompareTo(b.Pracownik);
        }
    }
    
    protected void Grid_BeforeRow(object sender, RowEventArgs args) {
        SymulacjaPracownika sp = (SymulacjaPracownika)args.Row;
        foreach (SymulacjaElementu se in sp.Elementy) {
            colElement.AddLine(se.Definicja);
            
            colWartość.AddLine(se.Wartość);
            colNarzuty.AddLine(se.Narzuty);
            
            colWartośćPo.AddLine(se.WartośćPo);
            colNarzutyPo.AddLine(se.NarzutyPo);
        }
    }

    string Format(decimal d) {
        return d == 0 ? "" : string.Format("{0}", d);
    }
    
    static void Msg(object value) {
    }

</script>

<HTML>
	<HEAD>
		<TITLE>Symulacja przeszeregowania</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad" landscape="true"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" runat="server" title="Symulacja przeszeregowania|</strong>Przeszeregowanie: <strong>%NAZWA%|</strong>Data: <strong>%DATA%"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" OnBeforeRow="Grid_BeforeRow" GroupData0="PracHistoria.Etat.Wydzial" GroupLine="Wydział: {0}" ShowGroupSum="True">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." runat="server"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="Pracownik.NazwiskoImię" Caption="Pracownik"></ea:GridColumn>
					<ea:GridColumn ID="colStanowisko" runat="server" Width="30" Align="Left" DataMember="PracHistoria.Etat.Stanowisko" Caption="Stanowisko"></ea:GridColumn>
                    <ea:GridColumn ID="colElement" runat="server" Caption="Element" Width="30" NoWrap="True" VAlign="Top" Total="Info">
                    </ea:GridColumn>
                    <ea:GridColumn ID="colWartość" runat="server" Caption="Przed~Wartość" Align="Right" Width="12" VAlign="Top" HideZero="True" Total="Sum" Format="{0:n}">
                    </ea:GridColumn>
                    <ea:GridColumn ID="colNarzuty" runat="server" Caption="Przed~Narzuty" Align="Right" Width="12" VAlign="Top" HideZero="True" Total="Sum" Format="{0:n}">
                    </ea:GridColumn>
                    <ea:GridColumn ID="colWartośćPo" runat="server" Align="Right" Caption="Po~Wartość"
                        VAlign="Top" Width="12" HideZero="True" Total="Sum" Format="{0:n}">
                    </ea:GridColumn>
                    <ea:GridColumn ID="colNarzutyPo" runat="server" Align="Right" Caption="Po~Narzuty"
                        VAlign="Top" Width="12" HideZero="True" Total="Sum" Format="{0:n}">
                    </ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>

